#include <iostream>
#include <bits/stdc++.h>

using namespace std;

struct Jarbol {
    long long x, h;
};

vector<long long> najbliziLevo(vector<Jarbol> &jarboli, int n)
{
    vector<long long> levi(n, -1);
    stack<long long> s;
    
    for (int i = 0; i < n; i++)
    {
        while (!s.empty() && jarboli[s.top()].h < jarboli[i].h)
            s.pop();
        
        if (!s.empty())
            levi[i] = s.top();
        
        s.push(i);
    }
    
    return levi;
}

vector<long long> najbliziDesno(vector<Jarbol> &jarboli, int n)
{
    vector<long long> desni(n, -1);
    stack<long long> s;
    
    for(long long i=n-1; i>=0; i--)
    {
        while(!s.empty() && jarboli[s.top()].h < jarboli[i].h)
            s.pop();
        
        if(!s.empty())
            desni[i] = s.top();
        
        s.push(i);
    }
    
    return desni;
}

bool sortiraj (Jarbol &a, Jarbol &b)
{
    return a.x < b.x;
}

int main()
{
    int n;
    cin>>n;
    vector<Jarbol> jarboli;
    for(int i=0; i<n; i++)
    {
        int x;
        cin>>x;
        Jarbol J;
        J.x = x;
        jarboli.push_back(J);
    }
    
    for(int i=0; i<n; i++)
    {
        int h;
        cin>>h;
        jarboli[i].h = h;
    }
    
    sort(jarboli.begin(), jarboli.end(), sortiraj);
    
    vector<long long> leviNajblizi = najbliziLevo(jarboli, n);
    vector<long long> desniNajblizi = najbliziDesno(jarboli, n);
    vector<long long> nizNajblizih;
    for(int i=0; i<n; i++)
    {
        long long levi = leviNajblizi[i];
        long long desni = desniNajblizi[i];
        
        long long najblizi = -1;
        if(levi != -1)
            najblizi = levi;
        
        if(desni != -1)
        {
            if(levi == -1)
                najblizi = desni;
            else if(abs(jarboli[i].x - jarboli[levi].x) < abs(jarboli[i].x - jarboli[desni].x))
                najblizi = levi;
            else
                najblizi = desni;
        }
        nizNajblizih.push_back(najblizi);
    }
    
    cout << endl;
    for(long long i=0; i<n; i++)
        cout << nizNajblizih[i] << endl;

    return 0;
}